<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- define the resource strings as variables and deliver to localization team -->
  <!-- Localization support : start -->
  <xsl:variable name ="ReportTitle">
    <xsl:text>Feature Check Report</xsl:text>
  </xsl:variable>

  <xsl:variable name ="OverallResults">
    <xsl:text>Summary</xsl:text>
  </xsl:variable>
  <xsl:variable name ="OverallResults_Success">
    <xsl:text>Success</xsl:text>
  </xsl:variable>
  <xsl:variable name ="OverallResults_Warning">
    <xsl:text>Warning</xsl:text>
  </xsl:variable>
  <xsl:variable name ="OverallResults_Failure">
    <xsl:text>Failure</xsl:text>
  </xsl:variable>

  <xsl:variable name ="Features">
    <xsl:text>Details</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Features_UnsupportedOption">
    <xsl:text>The feature uses following unsupported options</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Tips">
    <xsl:text>Tips: </xsl:text>
  </xsl:variable>
  <xsl:variable name ="Features_TipOption">
    <xsl:text>You can create the feature with following options</xsl:text>
  </xsl:variable>

  <xsl:variable name ="ObjectName">
    <xsl:text>Name</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Severity">
    <xsl:text>Severity</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Message">
    <xsl:text>Message</xsl:text>
  </xsl:variable>

  <xsl:variable name ="FeatureType">
    <xsl:text>Type</xsl:text>
  </xsl:variable>
  <xsl:variable name ="FeatureType_Extrusion">
    <xsl:text>Extrude</xsl:text>
  </xsl:variable>
  <xsl:variable name ="FeatureType_Revolution">
    <xsl:text>Revolve</xsl:text>
  </xsl:variable>
  <xsl:variable name ="FeatureType_Sweep">
    <xsl:text>Sweep</xsl:text>
  </xsl:variable>
  <xsl:variable name ="FeatureType_Unsupported">
    <xsl:text>Unsupported</xsl:text>
  </xsl:variable>

  <xsl:variable name ="Status">
    <xsl:text>Status</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Status_Successful">
    <xsl:text>Success</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Status_Warning">
    <xsl:text>Warning</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Status_Failure">
    <xsl:text>Failure</xsl:text>
  </xsl:variable>

  <!-- Localization support : end -->


  <xsl:key name="FeatureFilter" match="/LogData/Part/PartFeatures/*[local-name()='PartFeature' or local-name()='GeneralSickFeature' or local-name()='UnsupportedFeature']" use="@Status" />
  <xsl:key name="ConnectorFilter" match="/LogData/Part/Connectors/Connector" use="@Status" />

  <xsl:template match="/">

    <html xmlns:TranslationData="http://www.autodesk.com/Inventor/Translation">

      <!-- Html head - CSS and Scripts -->
      <head>
        <META http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <title>
          <xsl:value-of select="$ReportTitle"/>
        </title>
        <style type="text/css">
          body 	{	background-color: white; color: black; font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: normal; text-align: left; text-indent: 0pt; margin-bottom: 0pt; margin-left: 12pt; margin-right: 12pt; margin-top: 6pt;	}
          th	{	font-size: 12pt; font-weight: bold; margin-top: 12pt; margin-bottom: 3pt; text-align: left; background-color: #bbbbbb;	}
          td {	font-size: 10pt; font-weight: normal; margin-top: 12pt; margin-bottom: 3pt;	}
          table table th { font-size: 10pt; font-weight: bold; margin-top: 10pt; margin-bottom: 3pt; text-align: left; background-color:#eeeeee; }
          table table td {	font-size: 10pt; font-weight: normal; margin-top: 12pt; margin-bottom: 3pt;	}
          tr.row-style0 {	background-color: #ddddff;	}
          tr.row-style1 {	background-color: #eeeeff;	}
          .title 	{	color: #003399; font-size: 14pt; font-weight: bold;	}
          .header-heading {	font-weight: bold;	}
          .section-heading	{ color: #003399; font-size: 12pt; font-weight: bold; margin-top: 12pt; margin-bottom: 8pt;	}
          .table-description	{ margin-top: 6pt; margin-bottom: 3pt;	}
          .timestamp {	font-size: 9pt; font-weight: normal; color: #003399; text-align: right;	}
          .plus-minus {	text-align: center; font-family: monospace; font-weight: bold; cursor: pointer; cursor: hand; }
          .plus-minus-no-cursor {	text-align: center; font-family: monospace; font-weight: bold; }
          .status-error {	color: CC0000; font-weight: bold;	}
          .status-warning {	color: #999900; font-weight: bold;	}
          .status-message {	color: #003366; font-weight: bold;	}
          .status-unknown {	color: #660066; font-weight: bold;	}
          .status-debug	{	color: #660066; font-weight: bold;	}
          .status-success {	color: #006600;	}
          .foot { height: 70px;	}
        </style>
        <script language="JavaScript" type="text/javascript">
          function setDisplay(id, displayStyle)
          {
          el = document.getElementById(id)
          if (el != null)
          el.style.display = displayStyle;
          }

          function hide(id)
          {
          setDisplay(id, "none");
          }

          function show(id)
          {
          setDisplay(id, "");
          }

          function Expand(row, prefix)
          {
          hide(prefix + "plus" + row);
          show(prefix + "minus" + row);
          show(prefix + "details" + row);
          }

          function Collapse(row, prefix)
          {
          show(prefix + "plus" + row);
          hide(prefix + "minus" + row);
          hide(prefix + "details" + row);
          }

          function ChangeAll(fnChange, prefix)
          {
          row = 1;
          while(document.getElementById(prefix + "row" + row) != null)
          fnChange(row++, prefix);
          }

          function ExpandAll(prefix)
          {
          ChangeAll(Expand, prefix);
          }

          function CollapseAll(prefix)
          {
          ChangeAll(Collapse, prefix);
          }
        </script>
      </head>


      <body>
        <!-- Title table -->
        <table border="0" width="900">
          <tr>
            <td>
              <h1 class="title">
                <xsl:value-of select="$ReportTitle"/>
              </h1>
            </td>
            <!-- TODO: add timestamp to XML data -->
            <td class="timestamp">
              <xsl:value-of select="/LogData/Timestamp" />
            </td>
          </tr>
        </table>

        <!-- Overall result table -->
        <h2 class="section-heading">
          <xsl:value-of select="$OverallResults"/>
        </h2>
        <table width="500">
          <tr>
            <th>
              <xsl:value-of select="$OverallResults_Success"/>
            </th>
            <th>
              <xsl:value-of select="$OverallResults_Warning"/>
            </th>
            <th>
              <xsl:value-of select="$OverallResults_Failure"/>
            </th>
          </tr>

          <tr>
            <td class="status-success">
              <xsl:value-of select="count(key('FeatureFilter', 'Ok'))" />
            </td>
            <td class="status-warning">
              <xsl:value-of select="count(key('FeatureFilter', 'Warning'))" />
            </td>
            <td class="status-error">
              <xsl:value-of select="count(key('FeatureFilter', 'Error'))" />
            </td>
          </tr>

        </table>


        <!-- Feature status table -->
        <h2 class="section-heading" id="features">
          <xsl:value-of select="$Features"/>
        </h2>

        <table border="0" width="900">
          <col width="7%" />

          <!-- Table header -->
          <tr>
            <th>
              <div class="plus-minus">
                <span onclick="ExpandAll('feature-')">+</span>
                <span>/</span>
                <span onclick="CollapseAll('feature-')">-</span>
              </div>
            </th>
            <th>
              <xsl:value-of select="$ObjectName"/>
            </th>
            <th>
              <xsl:value-of select="$FeatureType"/>
            </th>
            <th>
              <xsl:value-of select="$Status"/>
            </th>
          </tr>
          <!-- Table items -->
          <xsl:for-each select="/LogData/Part/PartFeatures/*[local-name()='PartFeature' or local-name()='GeneralSickFeature' or local-name()='UnsupportedFeature']">

            <xsl:variable name="has_details">
              <xsl:choose>
                <xsl:when test="@Status != 'Ok'">
                  <xsl:value-of select="'true'" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="'false'" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>

            <!-- Feature summary -->
            <xsl:element name="tr">
              <xsl:attribute name="id">
                <xsl:value-of select="concat('feature-row', position())" />
              </xsl:attribute>
              <xsl:attribute name="class">
                <xsl:if test="position() mod 2 = 1">
                  row-style1
                </xsl:if>
                <xsl:if test="position() mod 2 = 0">
                  row-style0
                </xsl:if>
              </xsl:attribute>

              <td>
                <xsl:choose>
                  <xsl:when test="$has_details = 'true'">
                    <xsl:element name="div">
                      <xsl:attribute name="id">
                        <xsl:value-of select="concat('feature-plus', position())" />
                      </xsl:attribute>
                      <xsl:attribute name="onclick">
                        <xsl:value-of select="concat('Expand(', position(), ', &quot;feature-&quot;)')" />
                      </xsl:attribute>
                      <xsl:attribute name="class">
                        plus-minus
                      </xsl:attribute>
                      [+]
                    </xsl:element>

                    <xsl:element name="div">
                      <xsl:attribute name="id">
                        <xsl:value-of select="concat('feature-minus', position())" />
                      </xsl:attribute>
                      <xsl:attribute name="onclick">
                        <xsl:value-of select="concat('Collapse(', position(), ', &quot;feature-&quot;)')" />
                      </xsl:attribute>
                      <xsl:attribute name="class">
                        plus-minus
                      </xsl:attribute>
                      <xsl:attribute name="style">
                        display: none
                      </xsl:attribute>
                      [-]
                    </xsl:element>
                  </xsl:when>
                  <xsl:otherwise>
                    <div class="plus-minus-no-cursor">[ ]</div>
                  </xsl:otherwise>
                </xsl:choose>

              </td>

              <td>
                <xsl:value-of select="@Name" />
              </td>

              <td>
                <xsl:choose>
                  <xsl:when test="@Type = '1'">
                    <div class="FeatureType">
                      <xsl:value-of select="$FeatureType_Extrusion"/>
                    </div>
                  </xsl:when>
                  <xsl:when test="@Type = '2'">
                    <div class="FeatureType">
                      <xsl:value-of select="$FeatureType_Revolution"/>
                    </div>
                  </xsl:when>
                  <xsl:when test="@Type = '3'">
                    <div class="FeatureType">
                      <xsl:value-of select="$FeatureType_Sweep"/>
                    </div>
                  </xsl:when>
                  <xsl:otherwise>
                    <div class="FeatureType">
                      <xsl:value-of select="$FeatureType_Unsupported"/>
                    </div>
                  </xsl:otherwise>
                </xsl:choose>
              </td>

              <td>
                <xsl:choose>
                  <xsl:when test="@Status = 'Ok'">
                    <div class="status-success">
                      <xsl:value-of select="$Status_Successful"/>
                    </div>
                  </xsl:when>
                  <xsl:when test="@Status = 'Warning'">
                    <div class="status-warning">
                      <xsl:value-of select="$Status_Warning"/>
                    </div>
                  </xsl:when>
                  <xsl:otherwise>
                    <div class="status-error">
                      <xsl:value-of select="$Status_Failure"/>
                    </div>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </xsl:element>

            <!-- Feature details -->
            <xsl:if test="$has_details = 'true'">
              <xsl:element name="tr">
                <xsl:attribute name="id">
                  <xsl:value-of select="concat('feature-details', position())" />
                </xsl:attribute>
                <xsl:attribute name="style">
                  display: none
                </xsl:attribute>

                <td />
                <td colspan="2">
                  <table border="1" width="100%">
                    <col width="15%" />
                    <col width="85%" />
                    <tr>
                      <th>
                        <xsl:value-of select="$Severity"/>
                      </th>
                      <th>
                        <xsl:value-of select="$Message"/>
                      </th>
                    </tr>

                    <xsl:choose>
                      <!-- Unsupported cases -->
                      <xsl:when test="local-name()='UnsupportedFeature'">
                        <tr>
                          <td>
                            <div class="status-error">
                              <xsl:value-of select="$Status_Failure"/>
                            </div>
                          </td>
                          <td>

                            <xsl:variable name="IsUnsupportedFeatureType">
                              <xsl:choose>
                                <xsl:when test="@Type = '0'">
                                  <xsl:value-of select="'true'" />
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="'false'" />
                                </xsl:otherwise>
                              </xsl:choose>
                            </xsl:variable>
                            <xsl:if test="$IsUnsupportedFeatureType = 'true'">
                              <xsl:for-each select="Messages/Message[@Type='Error']">
                                <xsl:value-of select="DisplayText" />
                                <br />
                              </xsl:for-each>
                              <br />

                              <B>
                                <xsl:value-of select="$Tips"/>
                              </B>
                              <xsl:for-each select="Messages/Message[@Type='Tip']">
                                <xsl:value-of select="DisplayText" />
                                <br />
                              </xsl:for-each>
                            </xsl:if>
                            <xsl:if test="$IsUnsupportedFeatureType = 'false'">
                              <xsl:value-of select="$Features_UnsupportedOption"/>
                              <ul type="circle">
                                <xsl:for-each select="Messages/Message[@Type='Error']">
                                  <li>
                                    <xsl:value-of select="DisplayText" />
                                  </li>
                                </xsl:for-each>
                              </ul>
                              <br />

                              <B>
                                <xsl:value-of select="$Tips"/>
                              </B>
                              <xsl:value-of select="$Features_TipOption"/>
                              <ul type="circle">
                                <xsl:for-each select="Messages/Message[@Type='Tip']">
                                  <li>
                                    <xsl:value-of select="DisplayText" />
                                  </li>
                                </xsl:for-each>
                              </ul>
                            </xsl:if>

                          </td>
                        </tr>
                      </xsl:when>
                      <!-- Unexpected failures -->
                      <xsl:otherwise>
                        <!-- Log error message -->
                        <xsl:for-each select="Messages/Message[@Type='Error']">
                          <tr>
                            <td>
                              <div class="status-error">
                                <xsl:value-of select="$Status_Failure"/>
                              </div>
                            </td>
                            <td>
                              <xsl:value-of select="DisplayText" />
                            </td>
                          </tr>
                        </xsl:for-each>
                        <!-- Log warning message -->
                        <xsl:for-each select="Messages/Message[@Type='Warning']">
                          <tr>
                            <td>
                              <div class="status-warning">
                                <xsl:value-of select="$Status_Warning"/>
                              </div>
                            </td>
                            <td>
                              <xsl:value-of select="DisplayText" />
                            </td>
                          </tr>
                        </xsl:for-each>
                      </xsl:otherwise>
                    </xsl:choose>

                  </table>
                </td>

              </xsl:element>
            </xsl:if>

          </xsl:for-each>
        </table>


        <div class="foot"></div>
      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>