<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <!-- define the resource strings as variables and deliver to localization team -->
  <!-- Localization support : start -->
  <xsl:variable name ="ReportTitle">
    <xsl:text>Autodesk Inventor Translation Report</xsl:text>
  </xsl:variable>

  <xsl:variable name ="ReportTitle_SourceFile">
    <xsl:text>Source File:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="ReportTitle_TargetFile">
    <xsl:text>Target File:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="ReportTitle_TranslationType">
    <xsl:text>Translation Type:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="ReportTitle_RevitFamilyFile">
    <xsl:text>Revit Family File</xsl:text>
  </xsl:variable>
  <xsl:variable name ="ReportTitle_SendingSystem">
    <xsl:text>Sending System:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="ReportTitle_Author">
    <xsl:text>Author:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="ReportTitle_TranslationTime">
    <xsl:text>Translation Time:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="ReportTitle_Units">
    <xsl:text>Units:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="ReportTitle_BoundingBoxSize">
    <xsl:text>Bounding Box Size:</xsl:text>
  </xsl:variable>

  <xsl:variable name ="OverallResults">
    <xsl:text>Overall Results</xsl:text>
  </xsl:variable>
  <xsl:variable name ="OverallResults_ElementType">
    <xsl:text>Element Type</xsl:text>
  </xsl:variable>
  <xsl:variable name ="OverallResults_Number">
    <xsl:text>Number</xsl:text>
  </xsl:variable>
  <xsl:variable name ="OverallResults_Success">
    <xsl:text>Success</xsl:text>
  </xsl:variable>
  <xsl:variable name ="OverallResults_Warning">
    <xsl:text>Warning</xsl:text>
  </xsl:variable>
  <xsl:variable name ="OverallResults_Failure">
    <xsl:text>Failure</xsl:text>
  </xsl:variable>
  <xsl:variable name ="OverallResults_Faces">
    <xsl:text>Faces</xsl:text>
  </xsl:variable>    

  <xsl:variable name ="Configuration">
    <xsl:text>Configuration</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Configuration_ComponentType">
    <xsl:text>Revit Family Type:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Configuration_Orientation">
    <xsl:text>Orientation:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Configuration_FamilyType">
    <xsl:text>Family Type:</xsl:text>
  </xsl:variable>

  <xsl:variable name ="ObjectName">
    <xsl:text>Name</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Severity">
    <xsl:text>Severity</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Message">
    <xsl:text>Message</xsl:text>
  </xsl:variable>

  <xsl:variable name ="Status">
    <xsl:text>Status</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Status_Successful">
    <xsl:text>Success</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Status_Warning">
    <xsl:text>Warning</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Status_Failure">
    <xsl:text>Failure</xsl:text>
  </xsl:variable>

  <xsl:variable name ="Connectors">
    <xsl:text>Connectors</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Connectors_TableDescription">
    <xsl:text>Connectors and connector links included on publish:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Connectors_Type">
    <xsl:text>Type</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Connectors_CableTray">
    <xsl:text>Cable Tray Connector</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Connectors_Conduit">
    <xsl:text>Conduit Connector</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Connectors_Duct">
    <xsl:text>Duct Connector</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Connectors_Electrical">
    <xsl:text>Electrical Connector</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Connectors_Pipe">
    <xsl:text>Pipe Connector</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Connectors_Link">
    <xsl:text>Connector Link</xsl:text>
  </xsl:variable>

  <xsl:variable name ="Properties">
    <xsl:text>Properties</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Properties_TableDescription">
    <xsl:text>The following table lists the converted properties:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Properties_Value">
    <xsl:text>Value</xsl:text>
  </xsl:variable>

  <xsl:variable name ="Parameters">
    <xsl:text>Parameters</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Parameters_TableDescription">
    <xsl:text>The following table lists the converted parameters:</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Parameters_Inventor">
    <xsl:text>Inventor Parameters</xsl:text>
  </xsl:variable>
  <xsl:variable name ="Parameters_Expression">
    <xsl:text>Expression</xsl:text>
  </xsl:variable>
  <!-- Localization support : end -->


  <xsl:key name="ConnectorFilter" match="/LogData/DerivedSubstituteData/Connectors/Connector" use="@Status" />

  <xsl:template match="/">

    <html xmlns:TranslationData="http://www.autodesk.com/Inventor/Translation">

      <!-- Html head - CSS and Scripts -->
      <head>
        <META http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <title>
          <xsl:value-of select="$ReportTitle"/>
        </title>
        <style type="text/css">
          body 	{	background-color: white; color: black; font-family: Arial, Helvetica, sans-serif; font-size: 10pt; font-style: normal; font-weight: normal; text-align: left; text-indent: 0pt; margin-bottom: 0pt; margin-left: 12pt; margin-right: 12pt; margin-top: 6pt;	}
          th	{	font-size: 12pt; font-weight: bold; margin-top: 12pt; margin-bottom: 3pt; text-align: left; background-color: #bbbbbb;	}
          td {	font-size: 10pt; font-weight: normal; margin-top: 12pt; margin-bottom: 3pt;	}
          table table th { font-size: 10pt; font-weight: bold; margin-top: 10pt; margin-bottom: 3pt; text-align: left; background-color:#eeeeee; }
          table table td {	font-size: 10pt; font-weight: normal; margin-top: 12pt; margin-bottom: 3pt;	}
          tr.row-style0 {	background-color: #ddddff;	}
          tr.row-style1 {	background-color: #eeeeff;	}
          .title 	{	color: #003399; font-size: 14pt; font-weight: bold;	}
          .header-heading {	font-weight: bold;	}
          .section-heading	{ color: #003399; font-size: 12pt; font-weight: bold; margin-top: 12pt; margin-bottom: 8pt;	}
          .table-description	{ margin-top: 6pt; margin-bottom: 3pt;	}
          .timestamp {	font-size: 9pt; font-weight: normal; color: #003399; text-align: right;	}
          .plus-minus {	text-align: center; font-family: monospace; font-weight: bold; cursor: pointer; cursor: hand; }
          .plus-minus-no-cursor {	text-align: center; font-family: monospace; font-weight: bold; }
          .status-error {	color: CC0000; font-weight: bold;	}
          .status-warning {	color: #999900; font-weight: bold;	}
          .status-message {	color: #003366; font-weight: bold;	}
          .status-unknown {	color: #660066; font-weight: bold;	}
          .status-debug	{	color: #660066; font-weight: bold;	}
          .status-success {	color: #006600;	}
          .foot { height: 70px;	}
        </style>
        <script language="JavaScript" type="text/javascript">
          function setDisplay(id, displayStyle)
          {
          el = document.getElementById(id)
          if (el != null)
          el.style.display = displayStyle;
          }

          function hide(id)
          {
          setDisplay(id, "none");
          }

          function show(id)
          {
          setDisplay(id, "");
          }

          function Expand(row, prefix)
          {
          hide(prefix + "plus" + row);
          show(prefix + "minus" + row);
          show(prefix + "details" + row);
          }

          function Collapse(row, prefix)
          {
          show(prefix + "plus" + row);
          hide(prefix + "minus" + row);
          hide(prefix + "details" + row);
          }

          function ChangeAll(fnChange, prefix)
          {
          row = 1;
          while(document.getElementById(prefix + "row" + row) != null)
          fnChange(row++, prefix);
          }

          function ExpandAll(prefix)
          {
          ChangeAll(Expand, prefix);
          }

          function CollapseAll(prefix)
          {
          ChangeAll(Collapse, prefix);
          }
        </script>
      </head>


      <body>
        <!-- Title table -->
        <table border="0" width="900">

          <tr>
            <td>
              <h1 class="title">
                <xsl:value-of select="$ReportTitle"/>
              </h1>
            </td>
            <!-- TODO: add timestamp to XML data -->
            <td class="timestamp">
              <xsl:value-of select="/LogData/Timestamp" />
            </td>
          </tr>
        </table>

        <!-- Basic information table -->
        <table border="0" width="900">
          <col width="25%" />
          <col width="25%" />
          <col width="25%" />
          <col width="25%" />

          <tr>
            <td class="header-heading">
              <xsl:value-of select="$ReportTitle_SourceFile"/>
            </td>
            <td colspan="3">
              <xsl:element name="a">
                <xsl:variable name="source_file" select="/LogData/SourceFile" />
                <xsl:attribute name="href">
                  <xsl:value-of select="$source_file" />
                </xsl:attribute>
                <xsl:value-of select="$source_file" />
              </xsl:element>
            </td>
          </tr>

          <tr>
            <td class="header-heading">
              <xsl:value-of select="$ReportTitle_TargetFile"/>
            </td>
            <td colspan="3">
              <xsl:element name="a">
                <xsl:variable name="target_file" select="/LogData/TargetFile" />
                <xsl:attribute name="href">
                  <xsl:value-of select="$target_file" />
                </xsl:attribute>
                <xsl:value-of select="$target_file" />
              </xsl:element>
            </td>
          </tr>

          <tr>
            <td class="header-heading">
              <xsl:value-of select="$ReportTitle_TranslationType"/>
            </td>
            <td>
              <xsl:value-of select="$ReportTitle_RevitFamilyFile"/>
            </td>
            <td class="header-heading">
              <xsl:value-of select="$ReportTitle_SendingSystem"/>
            </td>
            <td>
              <xsl:value-of select="/LogData/SendingSystem" />
            </td>
          </tr>

          <tr>
            <td class="header-heading">
              <xsl:value-of select="$ReportTitle_Author"/>
            </td>
            <td>
              <xsl:value-of select="/LogData/Author" />
            </td>
            <td class="header-heading">
              <xsl:value-of select="$ReportTitle_TranslationTime"/>
            </td>
            <td>
              <xsl:value-of select="/LogData/TranslationTime" />
            </td>
          </tr>
		  
		  <tr>
            <td class="header-heading">
              <xsl:value-of select="$ReportTitle_Units"/>
            </td>
            <td>
              <xsl:value-of select="/LogData/LengthUnits" />
            </td>
            <td class="header-heading">
              <xsl:value-of select="$ReportTitle_BoundingBoxSize"/>
            </td>
            <td>
              <xsl:value-of select="/LogData/BoundingBoxSize" />
            </td>
          </tr>

        </table>

        <!-- Warnings, if any -->
        <table width="900">
            <xsl:for-each select="/LogData/DerivedSubstituteData/Messages/Message">
                <tr>
                    <td>
                        <div class="status-warning">
                            <xsl:value-of select="DisplayText" />
                        </div>
                    </td>
                </tr>
            </xsl:for-each>
        </table>

          <!-- Overall result table -->
        <h2 class="section-heading">
          <xsl:value-of select="$OverallResults"/>
        </h2>
        <table width="500">
          <tr>
            <th>
              <xsl:value-of select="$OverallResults_ElementType"/>
            </th>
            <th>
              <xsl:value-of select="$OverallResults_Number"/>
            </th>
          </tr>

		  <xsl:variable name="Assembly">
			<xsl:value-of select="/LogData/IsAssembly" />
          </xsl:variable>
		  	  	  
		  <tr>
            <td>
				<xsl:value-of select="$OverallResults_Faces" />
            </td>
            <td class="status-success">
              <xsl:value-of select="/LogData/FaceCount" />
            </td>
          </tr>
		  
          <tr>
            <td>
              <a href="#connectors">
                <xsl:value-of select="$Connectors"/>
              </a>
            </td>
            <td class="status-success">
              <xsl:value-of select="count(/LogData/DerivedSubstituteData/Connectors/Connector)" />
            </td>
          </tr>

        </table>

        <!-- Configurations table -->
        <h2 class="section-heading">
          <xsl:value-of select="$Configuration"/>
        </h2>
        <table border="0" width="900">
          <col width="38%" />
          <col width="62%" />
		  
          <tr>
            <td class="header-heading">
              <xsl:value-of select="$Configuration_FamilyType"/>
            </td>
            <td>
              <xsl:value-of select="/LogData/Configuration/FamilyType" />
            </td>
          </tr>

          <tr>
            <td class="header-heading">
              <xsl:value-of select="$Configuration_ComponentType"/>
            </td>
            <td>
              <xsl:value-of select="/LogData/Configuration/ComponentType" />
            </td>
          </tr>

          <tr>
            <td class="header-heading">
              <xsl:value-of select="$Configuration_Orientation"/>
            </td>
            <td>
              <xsl:value-of select="/LogData/Configuration/Orientation" />
            </td>
          </tr>

        </table>

        <!-- Connector table -->
        <h2 class="section-heading" id="connectors">
          <xsl:value-of select="$Connectors"/>
        </h2>
        <p class="table-description">
          <xsl:value-of select="$Connectors_TableDescription"/>
        </p>
        <table border="0" width="900">
          <col width="7%" />
          <!-- Table header -->
          <tr>
            <th>
              <div class="plus-minus">
                <span onclick="ExpandAll('connector-')">+</span>
                <span>/</span>
                <span onclick="CollapseAll('connector-')">-</span>
              </div>
            </th>
            <th>
              <xsl:value-of select="$ObjectName"/>
            </th>
            <th>
              <xsl:value-of select="$Connectors_Type"/>
            </th>
            <th>
              <xsl:value-of select="$Status"/>
            </th>
          </tr>

          <!-- Table items -->
          <!-- connectors -->
          <xsl:for-each select="/LogData/DerivedSubstituteData/Connectors/Connector">

            <xsl:variable name="has_details">
              <xsl:choose>
                <xsl:when test="@Status != 'Ok'">
                  <xsl:value-of select="'true'" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="'false'" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>



            <!-- Connector summary -->
            <xsl:element name="tr">
              <xsl:attribute name="id">
                <xsl:value-of select="concat('connector-row', position())" />
              </xsl:attribute>
              <xsl:attribute name="class">
                <xsl:if test="position() mod 2 = 1">
                  row-style1
                </xsl:if>
                <xsl:if test="position() mod 2 = 0">
                  row-style0
                </xsl:if>
              </xsl:attribute>

              <td>
                <xsl:choose>
                  <xsl:when test="$has_details = 'true'">
                    <xsl:element name="div">
                      <xsl:attribute name="id">
                        <xsl:value-of select="concat('connector-plus', position())" />
                      </xsl:attribute>
                      <xsl:attribute name="onclick">
                        <xsl:value-of select="concat('Expand(', position(), ', &quot;connector-&quot;)')" />
                      </xsl:attribute>
                      <xsl:attribute name="class">
                        plus-minus
                      </xsl:attribute>
                      [+]
                    </xsl:element>

                    <xsl:element name="div">
                      <xsl:attribute name="id">
                        <xsl:value-of select="concat('connector-minus', position())" />
                      </xsl:attribute>
                      <xsl:attribute name="onclick">
                        <xsl:value-of select="concat('Collapse(', position(), ', &quot;connector-&quot;)')" />
                      </xsl:attribute>
                      <xsl:attribute name="class">
                        plus-minus
                      </xsl:attribute>
                      <xsl:attribute name="style">
                        display: none
                      </xsl:attribute>
                      [-]
                    </xsl:element>
                  </xsl:when>
                  <xsl:otherwise>
                    <div class="plus-minus-no-cursor">[ ]</div>
                  </xsl:otherwise>
                </xsl:choose>

              </td>

              <td>
                <xsl:value-of select="@Name" />
              </td>

              <td>
                <xsl:choose>
                  <xsl:when test="@Type = '1'">
                    <div class="ConnectorType">
                      <xsl:value-of select="$Connectors_CableTray"/>
                    </div>
                  </xsl:when>
                  <xsl:when test="@Type = '2'">
                    <div class="ConnectorType">
                      <xsl:value-of select="$Connectors_Conduit"/>
                    </div>
                  </xsl:when>
                  <xsl:when test="@Type = '3'">
                    <div class="ConnectorType">
                      <xsl:value-of select="$Connectors_Duct"/>
                    </div>
                  </xsl:when>
                  <xsl:when test="@Type = '4'">
                    <div class="ConnectorType">
                      <xsl:value-of select="$Connectors_Electrical"/>
                    </div>
                  </xsl:when>
                  <xsl:otherwise>
                    <div class="ConnectorType">
                      <xsl:value-of select="$Connectors_Pipe"/>
                    </div>
                  </xsl:otherwise>
                </xsl:choose>
              </td>

              <td>
                <xsl:choose>
                  <xsl:when test="@Status = 'Ok'">
                    <div class="status-success">
                      <xsl:value-of select="$Status_Successful"/>
                    </div>
                  </xsl:when>
                  <xsl:when test="@Status = 'Warning'">
                    <div class="status-warning">
                      <xsl:value-of select="$Status_Warning"/>
                    </div>
                  </xsl:when>
                  <xsl:otherwise>
                    <div class="status-error">
                      <xsl:value-of select="$Status_Failure"/>
                    </div>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </xsl:element>

            <xsl:if test="$has_details = 'true'">
              <xsl:element name="tr">
                <xsl:attribute name="id">
                  <xsl:value-of select="concat('connector-details', position())" />
                </xsl:attribute>
                <xsl:attribute name="style">
                  display: none
                </xsl:attribute>

                <td />
                <td colspan="3">
                  <table border="1" width="100%">
                    <col width="15%" />
                    <col width="85%" />
                    <tr>
                      <th>
                        <xsl:value-of select="$Severity"/>
                      </th>
                      <th>
                        <xsl:value-of select="$Message"/>
                      </th>
                    </tr>
                    <!-- Log error message -->
                    <xsl:for-each select="Messages/Message[@Type='Error']">
                      <tr>
                        <td>
                          <div class="status-error">
                            <xsl:value-of select="$Status_Failure"/>
                          </div>
                        </td>
                        <td>
                          <xsl:value-of select="DisplayText" />
                        </td>
                      </tr>
                    </xsl:for-each>
                    <!-- Log warning message -->
                    <xsl:for-each select="Messages/Message[@Type='Warning']">
                      <tr>
                        <td>
                          <div class="status-warning">
                            <xsl:value-of select="$Status_Warning"/>
                          </div>
                        </td>
                        <td>
                          <xsl:value-of select="DisplayText" />
                        </td>
                      </tr>
                    </xsl:for-each>
                  </table>
                </td>

              </xsl:element>
            </xsl:if>

          </xsl:for-each>

          <!-- connector links -->
          <xsl:variable name="connectorCount" select="count(/LogData/DerivedSubstituteData/Connectors/Connector)"></xsl:variable>
          <xsl:for-each select="/LogData/DerivedSubstituteData/ConnectorLinks/ConnectorLink">

            <xsl:variable name="has_details">
              <xsl:choose>
                <xsl:when test="@Status != 'Ok'">
                  <xsl:value-of select="'true'" />
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="'false'" />
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>

            <!-- need calculate position when combining connector link to connector table -->
            <xsl:variable name="connectorLink_Pos" select="$connectorCount + position()"></xsl:variable>

            <!-- ConnectorLink summary -->
            <xsl:element name="tr">
              <xsl:attribute name="id">
                <xsl:value-of select="concat('connector-row', $connectorLink_Pos)" />
              </xsl:attribute>
              <xsl:attribute name="class">
                <xsl:if test="$connectorLink_Pos mod 2 = 1">
                  row-style1
                </xsl:if>
                <xsl:if test="$connectorLink_Pos mod 2 = 0">
                  row-style0
                </xsl:if>
              </xsl:attribute>

              <td>
                <xsl:choose>
                  <xsl:when test="$has_details = 'true'">
                    <xsl:element name="div">
                      <xsl:attribute name="id">
                        <xsl:value-of select="concat('connector-plus', $connectorLink_Pos)" />
                      </xsl:attribute>
                      <xsl:attribute name="onclick">
                        <xsl:value-of select="concat('Expand(', $connectorLink_Pos, ', &quot;connector-&quot;)')" />
                      </xsl:attribute>
                      <xsl:attribute name="class">
                        plus-minus
                      </xsl:attribute>
                      [+]
                    </xsl:element>

                    <xsl:element name="div">
                      <xsl:attribute name="id">
                        <xsl:value-of select="concat('connector-minus', $connectorLink_Pos)" />
                      </xsl:attribute>
                      <xsl:attribute name="onclick">
                        <xsl:value-of select="concat('Collapse(', $connectorLink_Pos, ', &quot;connector-&quot;)')" />
                      </xsl:attribute>
                      <xsl:attribute name="class">
                        plus-minus
                      </xsl:attribute>
                      <xsl:attribute name="style">
                        display: none
                      </xsl:attribute>
                      [-]
                    </xsl:element>
                  </xsl:when>
                  <xsl:otherwise>
                    <div class="plus-minus-no-cursor">[ ]</div>
                  </xsl:otherwise>
                </xsl:choose>

              </td>

              <td>
                <xsl:value-of select="@Name" />
              </td>

              <td>
                <div class="ConnectorType">
                  <xsl:value-of select="$Connectors_Link"/>
                </div>
              </td>

              <td>
                <xsl:choose>
                  <xsl:when test="@Status = 'Ok'">
                    <div class="status-success">
                      <xsl:value-of select="$Status_Successful"/>
                    </div>
                  </xsl:when>
                  <xsl:when test="@Status = 'Warning'">
                    <div class="status-warning">
                      <xsl:value-of select="$Status_Warning"/>
                    </div>
                  </xsl:when>
                  <xsl:otherwise>
                    <div class="status-error">
                      <xsl:value-of select="$Status_Failure"/>
                    </div>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </xsl:element>

            <xsl:if test="$has_details = 'true'">
              <xsl:element name="tr">
                <xsl:attribute name="id">
                  <xsl:value-of select="concat('connector-details', $connectorLink_Pos)" />
                </xsl:attribute>
                <xsl:attribute name="style">
                  display: none
                </xsl:attribute>

                <td />
                <td colspan="3">
                  <table border="1" width="100%">
                    <col width="15%" />
                    <col width="85%" />
                    <tr>
                      <th>
                        <xsl:value-of select="$Severity"/>
                      </th>
                      <th>
                        <xsl:value-of select="$Message"/>
                      </th>
                    </tr>
                    <!-- Log error message -->
                    <xsl:for-each select="Messages/Message[@Type='Error']">
                      <tr>
                        <td>
                          <div class="status-error">
                            <xsl:value-of select="$Status_Failure"/>
                          </div>
                        </td>
                        <td>
                          <xsl:value-of select="DisplayText" />
                        </td>
                      </tr>
                    </xsl:for-each>
                    <!-- Log warning message -->
                    <xsl:for-each select="Messages/Message[@Type='Warning']">
                      <tr>
                        <td>
                          <div class="status-warning">
                            <xsl:value-of select="$Status_Warning"/>
                          </div>
                        </td>
                        <td>
                          <xsl:value-of select="DisplayText" />
                        </td>
                      </tr>
                    </xsl:for-each>
                  </table>
                </td>

              </xsl:element>
            </xsl:if>

          </xsl:for-each>


        </table>

        <!-- Properties table -->
        <h2 class="section-heading" id="properties">
          <xsl:value-of select="$Properties"/>
        </h2>
        <p class="table-description">
          <xsl:value-of select="$Properties_TableDescription"/>
        </p>

        <table border="0" width="900">
          <col width="7%" />

          <!-- Inventor Property table -->
          <tr>
            <th>
              <div id="properties-plus1" onclick="Expand(1, &quot;properties-&quot;)" class="plus-minus">
                [+]
              </div>
              <div id="properties-minus1" onclick="Collapse(1, &quot;properties-&quot;)" class="plus-minus" style="display: none">
                [-]
              </div>
            </th>
            <th>
              <xsl:value-of select="$Properties"/>
            </th>
          </tr>
          <tr>
            <td></td>
            <td>
              <div id="properties-details1" style="display: none">
                <table border="0" width="100%" style="table-layout:fixed;word-wrap:break-word;">
                  <col width="7%" />
                  <col width="23%" />
                  <col width="40%" />
                  <col width="30%" />
                  <!-- Table header -->
                  <tr>
                    <th>
                      <div class="plus-minus">
                        <span onclick="ExpandAll('property-')">+</span>
                        <span>/</span>
                        <span onclick="CollapseAll('property-')">-</span>
                      </div>
                    </th>
                    <th>
                      <xsl:value-of select="$ObjectName"/>
                    </th>
                    <th>
                      <xsl:value-of select="$Properties_Value"/>
                    </th>
                    <th>
                      <xsl:value-of select="$Status"/>
                    </th>
                  </tr>

                  <!-- Table items -->
                  <xsl:for-each select="/LogData/DerivedSubstituteData/BIMComponentDescription/Properties/Property">

                    <xsl:variable name="has_details">
                      <xsl:choose>
                        <xsl:when test="@Status != 'Ok'">
                          <xsl:value-of select="'true'" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="'false'" />
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>


                    <!-- Property summary -->
                    <xsl:element name="tr">
                      <xsl:attribute name="id">
                        <xsl:value-of select="concat('property-row', position())" />
                      </xsl:attribute>
                      <xsl:attribute name="class">
                        <xsl:if test="position() mod 2 = 1">
                          row-style1
                        </xsl:if>
                        <xsl:if test="position() mod 2 = 0">
                          row-style0
                        </xsl:if>
                      </xsl:attribute>

                      <td>
                        <xsl:choose>
                          <xsl:when test="$has_details = 'true'">
                            <xsl:element name="div">
                              <xsl:attribute name="id">
                                <xsl:value-of select="concat('property-plus', position())" />
                              </xsl:attribute>
                              <xsl:attribute name="onclick">
                                <xsl:value-of select="concat('Expand(', position(), ', &quot;property-&quot;)')" />
                              </xsl:attribute>
                              <xsl:attribute name="class">
                                plus-minus
                              </xsl:attribute>
                              [+]
                            </xsl:element>

                            <xsl:element name="div">
                              <xsl:attribute name="id">
                                <xsl:value-of select="concat('property-minus', position())" />
                              </xsl:attribute>
                              <xsl:attribute name="onclick">
                                <xsl:value-of select="concat('Collapse(', position(), ', &quot;property-&quot;)')" />
                              </xsl:attribute>
                              <xsl:attribute name="class">
                                plus-minus
                              </xsl:attribute>
                              <xsl:attribute name="style">
                                display: none
                              </xsl:attribute>
                              [-]
                            </xsl:element>
                          </xsl:when>
                          <xsl:otherwise>
                            <div class="plus-minus-no-cursor">[ ]</div>
                          </xsl:otherwise>
                        </xsl:choose>

                      </td>

                      <td>
                        <xsl:value-of select="@Name" />
                      </td>
                      <td>
                        <xsl:value-of select="@Value" />
                      </td>

                      <td>
                        <xsl:choose>
                          <xsl:when test="@Status = 'Ok'">
                            <div class="status-success">
                              <xsl:value-of select="$Status_Successful"/>
                            </div>
                          </xsl:when>
                          <xsl:when test="@Status = 'Warning'">
                            <div class="status-warning">
                              <xsl:value-of select="$Status_Warning"/>
                            </div>
                          </xsl:when>
                          <xsl:otherwise>
                            <div class="status-error">
                              <xsl:value-of select="$Status_Failure"/>
                            </div>
                          </xsl:otherwise>
                        </xsl:choose>
                      </td>
                    </xsl:element>

                    <!-- Property summary -->
                    <xsl:if test="$has_details = 'true'">
                      <xsl:element name="tr">
                        <xsl:attribute name="id">
                          <xsl:value-of select="concat('property-details', position())" />
                        </xsl:attribute>
                        <xsl:attribute name="style">
                          display: none
                        </xsl:attribute>

                        <td />
                        <td colspan="3">
                          <table border="1" width="100%">
                            <col width="15%" />
                            <col width="85%" />
                            <tr>
                              <th>
                                <xsl:value-of select="$Severity"/>
                              </th>
                              <th>
                                <xsl:value-of select="$Message"/>
                              </th>
                            </tr>
                            <!-- Log error message -->
                            <xsl:for-each select="Messages/Message[@Type='Error']">
                              <tr>
                                <td>
                                  <div class="status-error">
                                    <xsl:value-of select="$Status_Failure"/>
                                  </div>
                                </td>
                                <td>
                                  <xsl:value-of select="DisplayText" />
                                </td>
                              </tr>
                            </xsl:for-each>
                            <!-- Log warning message -->
                            <xsl:for-each select="Messages/Message[@Type='Warning']">
                              <tr>
                                <td>
                                  <div class="status-warning">
                                    <xsl:value-of select="$Status_Warning"/>
                                  </div>
                                </td>
                                <td>
                                  <xsl:value-of select="DisplayText" />
                                </td>
                              </tr>
                            </xsl:for-each>
                          </table>
                        </td>

                      </xsl:element>
                    </xsl:if>

                  </xsl:for-each>

                </table>

              </div>
            </td>
          </tr>
        </table>

        <!-- Parameters table -->
        <h2 class="section-heading" id="parameters">
          <xsl:value-of select="$Parameters"/>
        </h2>
        <p class="table-description">
          <xsl:value-of select="$Parameters_TableDescription"/>
        </p>

        <table border="0" width="900">
          <col width="7%" />

          <!-- Inventor Parameter table -->
          <tr>
            <th>
              <div id="parameters-plus1" onclick="Expand(1, &quot;parameters-&quot;)" class="plus-minus">
                [+]
              </div>
              <div id="parameters-minus1" onclick="Collapse(1, &quot;parameters-&quot;)" class="plus-minus" style="display: none">
                [-]
              </div>
            </th>
            <th>
              <xsl:value-of select="$Parameters_Inventor"/>
            </th>
          </tr>
          <tr>
            <td></td>
            <td>
              <div id="parameters-details1" style="display: none">
                <table border="0" width="100%" style="table-layout:fixed;word-wrap:break-word;">
                  <col width="7%" />
                  <col width="23%" />
                  <col width="40%" />
                  <col width="30%" />
                  <!-- Table header -->
                  <tr>
                    <th>
                      <div class="plus-minus">
                        <span onclick="ExpandAll('parameter-')">+</span>
                        <span>/</span>
                        <span onclick="CollapseAll('parameter-')">-</span>
                      </div>
                    </th>
                    <th>
                      <xsl:value-of select="$ObjectName"/>
                    </th>
                    <th>
                      <xsl:value-of select="$Parameters_Expression"/>
                    </th>
                    <th>
                      <xsl:value-of select="$Status"/>
                    </th>
                  </tr>

                  <!-- Table items -->
                  <xsl:for-each select="/LogData/DerivedSubstituteData/Parameters/Parameter[@IsAuxiliary=0]">

                    <xsl:variable name="IsExposed">
                      <xsl:choose>
                        <xsl:when test="@IsExportToRevit = '1'">
                          <xsl:value-of select="'true'" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="'false'" />
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>

                    <xsl:if test="$IsExposed = 'true'">

                      <xsl:variable name="has_details">
                        <xsl:choose>
                          <xsl:when test="@Status != 'Ok'">
                            <xsl:value-of select="'true'" />
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="'false'" />
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>


                      <!-- Parameter summary -->
                      <xsl:element name="tr">
                        <xsl:attribute name="id">
                          <xsl:value-of select="concat('parameter-row', position())" />
                        </xsl:attribute>
                        <xsl:attribute name="class">
                          <xsl:if test="position() mod 2 = 1">
                            row-style1
                          </xsl:if>
                          <xsl:if test="position() mod 2 = 0">
                            row-style0
                          </xsl:if>
                        </xsl:attribute>

                        <td>
                          <xsl:choose>
                            <xsl:when test="$has_details = 'true'">
                              <xsl:element name="div">
                                <xsl:attribute name="id">
                                  <xsl:value-of select="concat('parameter-plus', position())" />
                                </xsl:attribute>
                                <xsl:attribute name="onclick">
                                  <xsl:value-of select="concat('Expand(', position(), ', &quot;parameter-&quot;)')" />
                                </xsl:attribute>
                                <xsl:attribute name="class">
                                  plus-minus
                                </xsl:attribute>
                                [+]
                              </xsl:element>

                              <xsl:element name="div">
                                <xsl:attribute name="id">
                                  <xsl:value-of select="concat('parameter-minus', position())" />
                                </xsl:attribute>
                                <xsl:attribute name="onclick">
                                  <xsl:value-of select="concat('Collapse(', position(), ', &quot;parameter-&quot;)')" />
                                </xsl:attribute>
                                <xsl:attribute name="class">
                                  plus-minus
                                </xsl:attribute>
                                <xsl:attribute name="style">
                                  display: none
                                </xsl:attribute>
                                [-]
                              </xsl:element>
                            </xsl:when>
                            <xsl:otherwise>
                              <div class="plus-minus-no-cursor">[ ]</div>
                            </xsl:otherwise>
                          </xsl:choose>

                        </td>

                        <td>
                          <xsl:value-of select="@Name" />
                        </td>
                        <td>
                          <xsl:value-of select="@Expression" />
                        </td>

                        <td>
                          <xsl:choose>
                            <xsl:when test="@Status = 'Ok'">
                              <div class="status-success">
                                <xsl:value-of select="$Status_Successful"/>
                              </div>
                            </xsl:when>
                            <xsl:when test="@Status = 'Warning'">
                              <div class="status-warning">
                                <xsl:value-of select="$Status_Warning"/>
                              </div>
                            </xsl:when>
                            <xsl:otherwise>
                              <div class="status-error">
                                <xsl:value-of select="$Status_Failure"/>
                              </div>
                            </xsl:otherwise>
                          </xsl:choose>
                        </td>
                      </xsl:element>

                      <!-- Parameter summary -->
                      <xsl:if test="$has_details = 'true'">
                        <xsl:element name="tr">
                          <xsl:attribute name="id">
                            <xsl:value-of select="concat('parameter-details', position())" />
                          </xsl:attribute>
                          <xsl:attribute name="style">
                            display: none
                          </xsl:attribute>

                          <td />
                          <td colspan="3">
                            <table border="1" width="100%">
                              <col width="15%" />
                              <col width="85%" />
                              <tr>
                                <th>
                                  <xsl:value-of select="$Severity"/>
                                </th>
                                <th>
                                  <xsl:value-of select="$Message"/>
                                </th>
                              </tr>
                              <!-- Log error message -->
                              <xsl:for-each select="Messages/Message[@Type='Error']">
                                <tr>
                                  <td>
                                    <div class="status-error">
                                      <xsl:value-of select="$Status_Failure"/>
                                    </div>
                                  </td>
                                  <td>
                                    <xsl:value-of select="DisplayText" />
                                  </td>
                                </tr>
                              </xsl:for-each>
                              <!-- Log warning message -->
                              <xsl:for-each select="Messages/Message[@Type='Warning']">
                                <tr>
                                  <td>
                                    <div class="status-warning">
                                      <xsl:value-of select="$Status_Warning"/>
                                    </div>
                                  </td>
                                  <td>
                                    <xsl:value-of select="DisplayText" />
                                  </td>
                                </tr>
                              </xsl:for-each>
                            </table>
                          </td>

                        </xsl:element>
                      </xsl:if>

                    </xsl:if>
                  </xsl:for-each>

                </table>

              </div>
            </td>

            <td></td>
            <td>
              <div id="parameters-details2" style="display: none">
                <table border="0" width="100%" style="table-layout:fixed;word-wrap:break-word;">
                  <col width="7%" />
                  <col width="23%" />
                  <col width="40%" />
                  <col width="30%" />
                  <!-- Table header -->
                  <tr>
                    <th>
                      <div class="plus-minus">
                        <span onclick="ExpandAll('parameter-')">+</span>
                        <span>/</span>
                        <span onclick="CollapseAll('parameter-')">-</span>
                      </div>
                    </th>
                    <th>
                      <xsl:value-of select="$ObjectName"/>
                    </th>
                    <th>
                      <xsl:value-of select="$Parameters_Expression"/>
                    </th>
                    <th>
                      <xsl:value-of select="$Status"/>
                    </th>
                  </tr>

                  <!-- Table items -->
                  <xsl:for-each select="/LogData/DerivedSubstituteData/PartFeatures//Parameter[@IsAuxiliary=1]">

                    <xsl:variable name="IsExposed">
                      <xsl:choose>
                        <xsl:when test="@IsExportToRevit = '1'">
                          <xsl:value-of select="'true'" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="'false'" />
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>

                    <xsl:if test="$IsExposed = 'true'">

                      <xsl:variable name="has_details">
                        <xsl:choose>
                          <xsl:when test="@Status != 'Ok'">
                            <xsl:value-of select="'true'" />
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="'false'" />
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:variable>


                      <!-- Parameter summary -->
                      <xsl:element name="tr">
                        <xsl:attribute name="id">
                          <xsl:value-of select="concat('parameter-row', position())" />
                        </xsl:attribute>
                        <xsl:attribute name="class">
                          <xsl:if test="position() mod 2 = 1">
                            row-style1
                          </xsl:if>
                          <xsl:if test="position() mod 2 = 0">
                            row-style0
                          </xsl:if>
                        </xsl:attribute>

                        <td>
                          <xsl:choose>
                            <xsl:when test="$has_details = 'true'">
                              <xsl:element name="div">
                                <xsl:attribute name="id">
                                  <xsl:value-of select="concat('parameter-plus', position())" />
                                </xsl:attribute>
                                <xsl:attribute name="onclick">
                                  <xsl:value-of select="concat('Expand(', position(), ', &quot;parameter-&quot;)')" />
                                </xsl:attribute>
                                <xsl:attribute name="class">
                                  plus-minus
                                </xsl:attribute>
                                [+]
                              </xsl:element>

                              <xsl:element name="div">
                                <xsl:attribute name="id">
                                  <xsl:value-of select="concat('parameter-minus', position())" />
                                </xsl:attribute>
                                <xsl:attribute name="onclick">
                                  <xsl:value-of select="concat('Collapse(', position(), ', &quot;parameter-&quot;)')" />
                                </xsl:attribute>
                                <xsl:attribute name="class">
                                  plus-minus
                                </xsl:attribute>
                                <xsl:attribute name="style">
                                  display: none
                                </xsl:attribute>
                                [-]
                              </xsl:element>
                            </xsl:when>
                            <xsl:otherwise>
                              <div class="plus-minus-no-cursor">[ ]</div>
                            </xsl:otherwise>
                          </xsl:choose>

                        </td>

                        <td>
                          <xsl:value-of select="@Name" />
                        </td>
                        <td>
                          <xsl:value-of select="@Expression" />
                        </td>

                        <td>
                          <xsl:choose>
                            <xsl:when test="@Status = 'Ok'">
                              <div class="status-success">
                                <xsl:value-of select="$Status_Successful"/>
                              </div>
                            </xsl:when>
                            <xsl:when test="@Status = 'Warning'">
                              <div class="status-warning">
                                <xsl:value-of select="$Status_Warning"/>
                              </div>
                            </xsl:when>
                            <xsl:otherwise>
                              <div class="status-error">
                                <xsl:value-of select="$Status_Failure"/>
                              </div>
                            </xsl:otherwise>
                          </xsl:choose>
                        </td>
                      </xsl:element>

                      <!-- Parameter summary -->
                      <xsl:if test="$has_details = 'true'">
                        <xsl:element name="tr">
                          <xsl:attribute name="id">
                            <xsl:value-of select="concat('parameter-details', position())" />
                          </xsl:attribute>
                          <xsl:attribute name="style">
                            display: none
                          </xsl:attribute>

                          <td />
                          <td colspan="3">
                            <table border="1" width="100%">
                              <col width="15%" />
                              <col width="85%" />
                              <tr>
                                <th>
                                  <xsl:value-of select="$Severity"/>
                                </th>
                                <th>
                                  <xsl:value-of select="$Severity"/>
                                </th>
                              </tr>
                              <!-- Log error message -->
                              <xsl:for-each select="Messages/Message[@Type='Error']">
                                <tr>
                                  <td>
                                    <div class="status-error">
                                      <xsl:value-of select="$Status_Failure"/>
                                    </div>
                                  </td>
                                  <td>
                                    <xsl:value-of select="DisplayText" />
                                  </td>
                                </tr>
                              </xsl:for-each>
                              <!-- Log warning message -->
                              <xsl:for-each select="Messages/Message[@Type='Warning']">
                                <tr>
                                  <td>
                                    <div class="status-warning">
                                      <xsl:value-of select="$Status_Warning"/>
                                    </div>
                                  </td>
                                  <td>
                                    <xsl:value-of select="DisplayText" />
                                  </td>
                                </tr>
                              </xsl:for-each>
                            </table>
                          </td>

                        </xsl:element>
                      </xsl:if>

                    </xsl:if>
                  </xsl:for-each>

                </table>

              </div>
            </td>
          </tr>
        </table>


        <div class="foot"></div>
      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>