#NoEnv  ; Recommended for performance and compatibility with future AutoHotkey releases.
#SingleInstance force ; Only allow one instance of the script to run at a time.

; This is a helper function required by many of the scripts below.
waitRelease() {
    KeyWait Control
    KeyWait Shift
    KeyWait Alt
    }

;================================================================================
;=========================== SDL TRADOS STUDIO SCRIPTS ==========================
;================================================================================

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;                               --- Navigation and Window Management ---
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;---
; Title: Navigate Trados Views
; Description: Quickly switches between the Editor, Files, and Projects views in Trados Studio.
; Hotkey: Alt+E (Editor), Alt+F (Files), Alt+P (Projects)
;---
; Trados 2021+ Version
#IfWinActive ahk_exe SDLTradosStudio.exe
;;al editor (alt+e)
!e::
waitRelease()
MouseClick, left, 16, 930, 1, 0
Sleep, 100
MouseMove, 740, 77, 0
Sleep, 100
SendInput, {Escape}
Return
;;a Files (alt+f)
!f::
    waitRelease()
MouseClick, left, 16, 867, , 0
Sleep, 100
MouseMove, 312, 209, 0
Sleep, 100
SendInput, {Escape}
MouseMove, 117, 277, 0
Return
;a Projects (alt+p)
!p::
    waitRelease()
MouseClick, left, 16, 837,, 0
Sleep, 100
MouseMove, 312, 209, 0
Sleep, 100
SendInput, {Escape}
MouseMove, 210, 236, 0
Return
#IfWinActive

; Trados 2017 Version
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
;;al editor (alt+e)
!e::
waitRelease()
MouseClick, left, 33, 927, 1, 0
Sleep, 100
MouseMove, 740, 77, 0
Sleep, 100
SendInput, {Escape}
Return
;a Files (alt+f)
!f::
    waitRelease()
MouseClick, left, 16, 867, 1, 0
Sleep, 100
MouseMove, 312, 209, 0
Sleep, 100
SendInput, {Escape}
MouseMove, 134, 200, 0
Return
;a Projects (alt+p)
!p::
    waitRelease()
MouseClick, left, 16, 837, 1, 0
Sleep, 100
MouseMove, 312, 209, 0
Sleep, 100
SendInput, {Escape}
MouseMove, 210, 236, 0
Return
#IfWinActive

;---
; Title: Close Find and Replace Window
; Description: Closes the "Find and Replace" dialog box.
; Hotkey: Ctrl+Escape (in the Find and Replace window)
;---
#IfWinActive ahk_exe SDLTradosStudio.exe
#IfWinActive Find and Replace
^Escape::
SendInput, !c
WinWaitClose Find and Replace
SendInput, {Escape}
Return
#IfWinActive




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;                               ---  Package Actions ---
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;---
; Title: Open Package from Clipboard Path
; Description: Opens a Trados package using a folder path that is currently in the clipboard.
; Hotkey: Ctrl+Shift+P
;---
#IfWinActive ahk_exe SDLTradosStudio.exe
^+p::
SendInput ^!k ;Replace with your shortcut for 'Open Package'
WinWaitActive, ahk_class #32770
Sleep, 50
SendInput {F4}
SendInput ^a
SendInput ^v
SendInput {Enter}
Sleep, 500
SendInput {Tab}
Sleep, 50
SendInput {Escape}
Sleep, 50
SendInput {Down}
Sleep, 50
SendInput {Enter}
Return
#IfWinActive

;---
; Title: Create Package at Clipboard Path
; Description: Starts the "Create Project Package" wizard and uses the clipboard path as the destination.
; Hotkey: Ctrl+Shift+Ñ
;---
; Trados 2017 Version
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
^+ñ::
SendInput ^!l ;Replace with your shortcut for 'Create Project Package'
WinWaitActive, Create Project Package
Sleep, 50
SendInput {Enter}
Sleep, 900
SendInput {Tab 7}
Sleep,50
SendInput ^a
SendInput ^v
SendInput {Enter}
Sleep, 800
MouseClick, left, 427, 132
Sleep,50
SendInput {Tab}
SendRaw u
SendInput +{Tab}
Sleep,50
SendInput {End}
Return
#IfWinActive

; Trados 2019+ Version
#IfWinActive ahk_exe SDLTradosStudio.exe
^+ñ::
SendInput ^!l ;Replace with your shortcut for 'Create Project Package'
WinWaitActive, Create Project Package
Sleep, 50
SendInput {Enter}
Sleep, 900
SendInput {Tab}
Sleep,50
SendInput ^a
SendInput ^v
SendInput {Enter}
Sleep, 800
MouseClick, left, 320, 147
Sleep,50
SendInput {Tab}
SendRaw u
SendInput +{Tab}
Sleep,50
SendInput {End}
Return
#IfWinActive


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;                               --- Text Editing and Formatting ---
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;---
; Title: Convert Segment to Lowercase
; Description: Selects the entire current segment and converts it to lowercase.
; Hotkey: Ctrl+Shift+W
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
^+w::
SendInput ^a
Sleep, 300
SendInput !w ;Change with your 'Change case' Trados shortcut
Sleep, 300
SendInput !w  ;Change with your 'Change case' Trados shortcut
SendInput {Home}
Return
#IfWinActive

;---
; Title: Insert Non-Breaking Space
; Description: Inserts a non-breaking space in the editor.
; Hotkey: Shift+Space
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
+Space:: Send ^+{Space}
return
#IfWinActive

;---
; Title: Toggle Case of next Word
; Description: Selects the next word and toggles its case.
; Hotkey: F2
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
F2::
Sendinput {LCtrl down}{LShift down}{Right 1}{LCtrl up}{LShift up}
Sleep, 300
Send {LAlt down}{w} ;Change with your 'Change case' Trados shortcut
Sleep,50
Send {LAlt Up}
SendInput {Left}
Return
#IfWinActive

;---
; Title: Replace Spaces in Selection
; Description: Replaces all spaces in the selected text with hyphens.
; Hotkey: Ctrl+Ñ
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
^ñ::
SendInput ^c
Sleep,50
Clipboard := RegExReplace(Clipboard, "\s","-") ;guiones
Sleep,50
SendInput ^v
Return
#IfWinActive

;---
; Title: QuickPlace First/Second Suggestion
; Description: Activates QuickPlace and selects either the first or second suggestion from the list.
; Hotkey: Ctrl++ (First), Ctrl+` (Second)
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
^`::
Send ^ç
Sleep,200
Send {Down 1}
Sleep,80
Send {Enter}
Return
#IfWinActive

#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
^+::
Send ^ç
Sleep,200
Send {Enter}
Return
#IfWinActive

;---
; Title: Paste "Not In" Regex Code
; Description: Pastes a predefined regular expression used for filtering segments that do not contain a specific string. Just write/paste the text you want to filter out after running this function.
; Hotkey: Ctrl+Shift+Alt+Q
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
^+!q::
SendRaw ^((?!AAA).)*$
Sleep, 50
Send {Left 5}
Send {Backspace 3}
Return
#IfWinActive


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;                               --- Segment Actions ---
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;---
; Title: Merge Segments
; Description: Merges the current segment with the one below it.
; Hotkey: Ctrl+Shift+M
;---
#IfWinActive ahk_exe SDLTradosStudio.exe
^+m::
Send !{Space}
Send !{Down}
Send !{Space}
Send ^m ;Replace with your Trados shortcut for merging segments
Return
#IfWinActive

;---
; Title: Set Segment Status
; Description: A set of hotkeys to quickly change the status of the current segment (e.g., Translated, Signed Off, Rejected).
; Hotkey: Ctrl+NumpadDiv, Ctrl+NumpadMult, Ctrl+NumpadSub, etc.
;---
#IfWinActive ahk_exe SDLTradosStudio.exe
^NumpadDiv::
    waitRelease()
    Send {alt}h
    Sleep,200
    SendRaw {u}
    Sleep,200
    Send {Up 5} ;5=Trans.;  4=Trans. rej.; 2=Sign-off rej.; 3= Trans. appr.; 1=Sign. off;
    Send {Enter}
    ;;"bloquear segmento"
 Sleep,50
    Send ^l
    ;;"pasar al siguiente segmento"
    Sleep,50
    Send ^{Down}
return

^NumpadMult::
    waitRelease()
    Send {alt}h
    Sleep,200
    SendRaw {u}
    Sleep,200
        Send {Up 1} ;"Trans." = 5; "Sign. off" = 1; "Trans. rej". = 4; "Sign-off rej." = 2
    Send {Enter}
    ;;"bloquear segmento"
    Sleep,50
    Send ^l
    ;"pasar al siguiente segmento"
    Sleep,50
    Send ^{Down}
return

+^NumpadMult::
    waitRelease()
    Send {alt}h
    Sleep,200
    SendRaw {u}
    Sleep,200
        Send {Up 1} ;"Trans." = 5; "Sign. off" = 1; "Trans. rej". = 4; "Sign-off rej." = 2
    Send {Enter}
    Sleep,50
    ;;"pasar al siguiente segmento"
    ;Send ^{Down}
    ;;guardar
    SendInput, ^s
return

^NumpadSub::
    waitRelease()
Send !{Delete} ;borrar segmento
Sleep,50
    Send {alt}h
    Sleep,200
    SendRaw {u}
    Sleep,200
    Send {Up 2} ;"Trans." = 5; "Sign. off" = 1; "Trans. rej". = 4; "Sign-off rej." = 2
    Send {Enter}
    ;"bloquear segmento"
    Sleep,50
    Send ^l
    ;;"pasar al siguiente segmento"
Sleep,50
Send ^{Down}
    ;;colocar cursor en X posición
    MouseMove, 1841, 307
return

^+NumpadDiv::
    waitRelease()
Sleep,50
    Send {alt}h
    Sleep,200
    SendRaw {u}
    Sleep,200
    Send {Up 4} ;"Trans." = 5; "Sign. off" = 1; "Trans. rej". = 4; "Sign-off rej." = 2
    Send {Enter}
    ;"bloquear segmento"
    Sleep,50
    Send ^l
    ;"pasar al siguiente segmento"
    Sleep,50
    Send ^{Down}
return
#IfWinActive


;---
; Title: Select All Segments
; Description: Selects all segments in the active document (for older Trados versions, not always works).
; Hotkey: Alt+Shift+A
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
!+a::
SendInput ^{Home} ; Go to 1st segment
Sleep, 100
SendInput {Down}
Sleep, 100
SendInput !{Space} ; Select 1st segment
Sleep, 100
SendInput, ^+{End}
SendInput, +{Up}
Return
#IfWinActive

;---
; Title: Copy Source to Target
; Description: Copies the source text to the target segment.
; Hotkey: 5
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
5:: send !{Insert} ;Replace with your Trados shortcut for 'copy source to target'
return
#IfWinActive

;---
; Title: Copy Target and Overwrite with Source
; Description: Copies the content of the target segment, then overwrites it with the source text, while keeping the copied text in the clipboard (useful for editing fuzzies).
; Hotkey: Ctrl+Numpad5
;---
#IfWinActive ahk_exe SDLTradosStudio.exe
^Numpad5::
Send ^a
Sleep,80
Send ^c
Sleep,80
Send {LAlt Down}{Ins} ;Replace with your Trados shortcut for 'copy source to target'
Sleep,50
Send {LAlt Up}
Sleep,50
SendInput {Home}
SendInput ^{Right}
Sleep, 50
SendInput,  {Right 2}
SendInput, {Left 2}
Return
#IfWinActive


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;                               --- Search and Concordance ---
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;---
; Title: Concordance Search for Entire Source Segment
; Description: Copies the entire source segment and performs a concordance search.
; Hotkey: Ñ
;---
#IfWinActive ahk_exe SDLTradosStudio.exe
ñ::
SendInput, {F11} ;Replace with your Trados shortcut for 'Toggle between source and target'
Sleep, 200
SendInput, ^+{Down}
Sleep, 500
SendInput, {F3}
Sleep, 500
SendInput, {F11}
return
#IfWinActive

;---
; Title: Copy Concordance search to Target Segment
; Description: Copies translataion from first concordance search result  text and pastes it into the target segment (first make sure concordance search result is the first active pane when clicking ctrl+ tab).
; Hotkey: Ctrl+Shift+C
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
^+c::
SendInput ^{Tab}
Sleep, 1000
SendInput ^a
SendInput ^c
Sleep,50
SendInput {F11}^v ;Replace F11 with your Trados shortcut for 'Toggle between source and target'
Return
#IfWinActive

;---
; Title: Concordance Search with Hyphens as Spaces
; Description: Copies the source text, replaces hyphens with spaces, and then performs a concordance search.
; Hotkey: Ctrl+Shift+F3
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
^+F3::
    SendInput, {F11}
    Sleep, 100
    SendInput, ^+{Down}
    SendInput, ^c
    Sleep, 800
    nohyphens := RegExReplace(clipboard, "-", " ")
    Clipboard := nohyphens
    Sleep, 100
    SendInput, {Left}
    Sleep, 500
    SendInput, {F3}
    Sleep, 1000
    SendInput, ^v
    SendInput, {Enter}
    SendInput, {F11}
Return
#IfWinActive


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;                               --- Filtering ---
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;---
; Title: Go to Filter Box
; Description: Moves the cursor to the segment filter box.
; Hotkey: Ctrl+Alt+Q
;---
#IfWinActive ahk_exe SDLTradosStudio.exe
^!q::
    waitRelease()
    Sleep,50
    SendInput, ^{F6} ;Change with your Trados shortcut for 'Activate display filters'
    Sleep,50
    SendInput {Home}
    Sleep,50
    SendInput, {Shift}+{End}
return
#IfWinActive

;---
; Title: Open Filter Dropdown
; Description: Opens the filter's dropdown menu.
; Hotkey: Ctrl+Alt+D
;---
#IfWinActive ahk_exe SDLTradosStudio.exe
^!d::
    waitRelease()
    Send {alt}r
    Sleep,50
    SendRaw {l}
return
#IfWinActive

;---
; Title: Filter on Selected Text
; Description: Filters all segments based on the currently selected text.
; Hotkey: Ctrl+Alt+T
;---
#IfWinActive ahk_exe SDLTradosStudio.exe
^!t::
waitRelease()
Send ^c
Sleep 200
Send ^{F6} ;Change with your Trados shortcut for 'Activate display filters'
Sleep 200
Send ^v
Sleep 200
Send {Enter}
Sleep 100
Send {Control Down}{Home}{Control Up}{Down}
Return
#IfWinActive

;---
; Title: Filter Trados from Another App
; Description: Copies text from another application (like Excel or Xbench) and pastes it into the Trados filter, with options for "contains," "starts with," and "ends with" searches.
; Hotkey: Numpad1 (contains), Numpad2 (starts with), Numpad3 (ends with)
;---
;#IfWinActive ahk_exe EXCEL.EXE ;for  Excel
#IfWinActive ahk_class TMainForm ;for X-Bench
;#IfWinActive ahk_class PX_WINDOW_CLASS ;for SublimeText
;#IfWinActive ahk_class MozillaWindowClass ;for Firefox
;#IfWinActive ahk_class OpusApp ;for Word
NumPad1::
SendInput, ^c
Sleep,50
WinActivate, Trados Studio
WinWaitActive, Trados Studio
    waitRelease()
    SendInput {alt}rz1
    Sleep,50
    SendInput {Home}
    Sleep,50
    SendInput, {Shift}+{End}
    Sleep,300
    SendInput, ^+!v
        Sleep,50
    Clipboard := ""
    SendInput {Delete}
    SendInput {Enter}
return

NumPad2::
SendInput, ^c
Sleep,50
WinActivate, Trados Studio
WinWaitActive, Trados Studio
    waitRelease()
    SendInput {alt}rz1
    Sleep,50
    SendInput {Home}
    Sleep,50
    SendInput, {Shift}+{End}
    Sleep,50
    Send {asc 0094}
    Sleep,300
    SendInput, ^+!v
    Sleep,50
    Clipboard := ""
    SendInput {Delete}
    SendInput {Enter}
return

NumPad3::
SendInput, ^c
Sleep,50
WinActivate, Trados Studio
WinWaitActive, Trados Studio
    waitRelease()
    SendInput {alt}rz1
       Sleep,50
    SendInput {Home}
       Sleep,50
    SendInput, {Shift}+{End}
       Sleep,100
    SendInput, ^+!v
        Sleep,100
    SendInput, {Delete}
        Sleep, 50
    SendInput {Enter}
Sleep, 300
    SendInput {alt}r
       Sleep,50
    MouseClick, left, 950, 70
       Sleep,50
    SendInput {End}
       Sleep,50
    SendRaw, $
       Sleep,50
    SendInput {Enter}
return
#IfWinActive


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;                               --- Advanced and Miscellaneous ---
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;---
; Title: Paste Clipboard Sentence by Sentence
; Description: Pastes multi-sentence text from the clipboard into consecutive Trados segments, one sentence at a time.
; Hotkey: Ctrl+Shift+Alt+F4
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
^+!F4::
;;01. Run script for cleaning unwanted chars
SendInput, ^+!j
Sleep, 500
SendInput, ^+!j
Sleep, 1000

;; 02. Paste contents segment by segment
Loop
{
    if !WinActive("ahk_exe SDLTradosStudio.exe")
    {
        MsgBox, 4,, SDL Trados Studio is inactive. Would you like to (1) Pause or (2) Terminate the script?
        IfMsgBox, Yes
        {
            Pause
            WinWaitActive, ahk_exe SDLTradosStudio.exe
            Continue
        }
        else
        {
            ExitApp
        }
    }

    ClipWait, 1
    if (ErrorLevel)
    {
        MsgBox, Clipboard did not contain data within the timeout period.
        Break
    }

    clipboardContent := Clipboard
    position := RegExMatch(clipboardContent, "\R+|(?<=[.!?])\s+(?=[[:upper:]]|[ČĆĐŠŽ])")

    if (position > 0)
    {
        textBeforeSplit := SubStr(clipboardContent, 1, position - 1)
        remainingText := SubStr(clipboardContent, position)
        remainingText := RegExReplace(remainingText, "^(\R+|\s)", "")
        SendInput, ^a
        Sleep, 100
        
        Clipboard := textBeforeSplit
        Send, ^v

        Sleep, 100
        SendInput, {Escape}
        Clipboard := remainingText
        Sleep, 100
        SendInput, ^{Down}
        Sleep, 100
        SendInput, ^a
        Sleep, 200
    }
    else
    {
        SendInput, ^v
        Sleep, 200
        SendInput, ^{Down}
        Sleep, 300
        Break
    }
}
Clipboard := ""
#IfWinActive

return
;;Remove unwanted characters after copying from Excel
 ^+!j:: ; Trigger with Ctrl+J
{
    ; Save the current clipboard content to a variable
    ClipContent := Clipboard

    ; Split the clipboard content into an array of lines
    Lines := StrSplit(ClipContent, "`n") ; Split by newline character

    ; Initialize an empty variable to store the processed content
    FinalContent := ""

    ; Loop through each line and process it
    for Index, Line in Lines
    {
        ; Step 1: Remove double quotation marks at the beginning or end of the line
        Line := RegExReplace(Line, "^""|""$", "")

                ; Step 1: Remove double quotation marks at the beginning or end of the line
        Line := RegExReplace(Line, """""", """")

        ; Step 2: Remove one or more spaces at the end of the line
        Line := RegExReplace(Line, "\s+$", "")

        ; Step 3: Replace extra spaces (two or more) after full stops or colons with one space
        Line := RegExReplace(Line, "[.:]\K\s{2,}", " ")

        ; Append the processed line to the final content with a newline character
        FinalContent .= Line . "`n"
    }

    ; Remove the trailing newline character added during reassembly
    FinalContent := RTrim(FinalContent, "`n")

    ; Place the modified content back into the clipboard
    Clipboard := FinalContent

    ; Optional: Notify the user that the operation is complete
    ToolTip, Clipboard processed!`nNew content: %FinalContent%
    SetTimer, RemoveToolTip, 2000 ; Remove the tooltip after 2 seconds
    Return
}

RemoveToolTip:
    ToolTip ; Clear the tooltip
    SetTimer, RemoveToolTip, Off ; Turn off the timer
    Return


;---
; Title: Smart Punctuation Mirror
; Description: Automatically makes the final punctuation of the target segment match the source segment.
; Hotkey: Pause
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
Pause::
Sleep, 100
    Clipboard := ""
    Send, {F11} ;Replace with your Trados shortcut for 'Toggle source/target'
    Sleep, 180
    Send, ^+{Down}
    Sleep, 80
    Send, ^c
    ClipWait, 1
    srcText := Clipboard
    srcText := RTrim(srcText, "`r`n `t")

    Send, {F11} ;Replace with your Trados shortcut for 'Toggle source/target'
    Sleep, 180
    Send, ^a
    Sleep, 80
    Send, ^c
    ClipWait, 1
    trgText := Clipboard
    trgText := RTrim(trgText, "`r`n `t")

    RegExMatch(srcText, ".*(.)$", last)
    srcEnd := last1
    RegExMatch(trgText, ".*(.)$", last)
    trgEnd := last1

    punc := ",;:.?:!…"

    if InStr(punc, srcEnd) {
        if (trgEnd != srcEnd) {
            if InStr(punc, trgEnd)
                trgText := SubStr(trgText, 1, StrLen(trgText) - 1)
            trgText .= srcEnd
        }
    } else {
        if InStr(punc, trgEnd)
            trgText := SubStr(trgText, 1, StrLen(trgText) - 1)
    }

    Clipboard := trgText
    Sleep, 180
    Send, ^a
    Sleep, 100
    Send, ^v
#IfWinActive
Return

;---
; Title: Delete Comment
; Description: Navigates the context menu to delete a comment from the current segment.
; Hotkey: Shift+Delete
;---
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
+Delete::
    Send, {AppsKey}
    Sleep, 100
    Send, i
    Sleep, 80
    Send, {Tab}
    Sleep, 80
    Send, {Tab}
    Sleep, 80
    Send, {Tab}
    Sleep, 80
    Send, {Tab}
    Sleep, 80
    Send, {Enter}
    Sleep, 100
    Send, {Enter}
#IfWinActive
return
```