#SingleInstance force
#NoEnv
SendMode Input

;; Paste Clipboard Content in Trados, Segment by Segment (Phrase by Phrase)
#IfWinActive ahk_class WindowsForms10.Window.8.app.0.2bf8098_r9_ad1
#IfWinActive ahk_exe SDLTradosStudio.exe
^+!F4::
;;01. Run script for cleaning unwanted chars
SendInput, ^+!j
Sleep, 500
SendInput, ^+!j
Sleep, 1000

;; 02. Paste contents segment by segment
Loop
{
    ; Check if the SDL Trados window is active
    if !WinActive("ahk_exe SDLTradosStudio.exe")
    {
        ; Prompt the user to decide whether to pause or terminate the script
        MsgBox, 4,, SDL Trados Studio is inactive. Would you like to (1) Pause or (2) Terminate the script?
        IfMsgBox, Yes ; User chose to pause
        {
            ; Pause the script and wait for the user to resume
            Pause
            ; Wait until the window becomes active again
            WinWaitActive, ahk_exe SDLTradosStudio.exe
            ; Resume the script
            Continue
        }
        else ; User chose to terminate
        {
            ExitApp ; Terminate the script
        }
    }

    ; Wait for the clipboard to contain data with a timeout of 1 second
    ClipWait, 1
    if (ErrorLevel) ; Check if ClipWait timed out
    {
        MsgBox, Clipboard did not contain data within the timeout period.
        Break ; Exit the loop if the clipboard is empty
    }

    ; Retrieve the clipboard content
    clipboardContent := Clipboard

    ; Find the position of the first occurrence of one or more new lines OR the specified pattern
    position := RegExMatch(clipboardContent, "\R+|(?<=[.!?])\s+(?=[[:upper:]]|[ČĆĐŠŽ])")

    if (position > 0)
    {
        ; Extract the text before the split point
        textBeforeSplit := SubStr(clipboardContent, 1, position - 1)
        ; Extract the text after the split point
        remainingText := SubStr(clipboardContent, position)
        ; Remove leading newline characters or space from the remaining text
        remainingText := RegExReplace(remainingText, "^(\R+|\s)", "")
        ; Paste the text before the split point
        SendInput, ^a
        Sleep, 100
        
        Clipboard := textBeforeSplit  ; Store the text in the clipboard
        Send, ^v  ; Send Ctrl+V to paste

        Sleep, 100
        SendInput, {Escape}
        ; Set the clipboard to the remaining text
        Clipboard := remainingText
        ; Go to the next segment, click Escape and select all
        Sleep, 100
        SendInput, ^{Down}
        Sleep, 100
        SendInput, ^a
        Sleep, 200
    }
    else
    {
        ; For the last line of the clipboard, paste it directly
        SendInput, ^v
        Sleep, 200
        SendInput, ^{Down}
        Sleep, 300
        Break ; Exit the loop after pasting the last line
    }
}

; Clear the clipboard after the last paste operation
Clipboard := ""

#IfWinActive
return

;;#####################################################################

;;Remove unwanted characters after copying from Excel
 ^+!j:: ; Trigger with Ctrl+J
{
    ; Save the current clipboard content to a variable
    ClipContent := Clipboard

    ; Split the clipboard content into an array of lines
    Lines := StrSplit(ClipContent, "`n") ; Split by newline character

    ; Initialize an empty variable to store the processed content
    FinalContent := ""

    ; Loop through each line and process it
    for Index, Line in Lines
    {
        ; Step 1: Remove double quotation marks at the beginning or end of the line
        Line := RegExReplace(Line, "^""|""$", "")

                ; Step 1: Remove double quotation marks at the beginning or end of the line
        Line := RegExReplace(Line, """""", """")

        ; Step 2: Remove one or more spaces at the end of the line
        Line := RegExReplace(Line, "\s+$", "")

        ; Step 3: Replace extra spaces (two or more) after full stops or colons with one space
        Line := RegExReplace(Line, "[.:]\K\s{2,}", " ")

        ; Append the processed line to the final content with a newline character
        FinalContent .= Line . "`n"
    }

    ; Remove the trailing newline character added during reassembly
    FinalContent := RTrim(FinalContent, "`n")

    ; Place the modified content back into the clipboard
    Clipboard := FinalContent

    ; Optional: Notify the user that the operation is complete
    ToolTip, Clipboard processed!`nNew content: %FinalContent%
    SetTimer, RemoveToolTip, 2000 ; Remove the tooltip after 2 seconds
    Return
}

RemoveToolTip:
    ToolTip ; Clear the tooltip
    SetTimer, RemoveToolTip, Off ; Turn off the timer
    Return