<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xliff="urn:oasis:names:tc:xliff:document:1.2">

    <xsl:output method="html" encoding="UTF-8" indent="yes"/>

    <!-- Template to apply on the root element -->
    <xsl:template match="/">
        <html>
            <head>
                <title>Translation Units</title>
                <style>
                    body {
                        font-family: Arial, sans-serif;
                    }
                    .unit-table {
                        border-collapse: collapse;
                        margin-bottom: 20px;
                        width: 100%;
                    }
                    .unit-table, .unit-table th, .unit-table td {
                        border: 1px solid black;
                        padding: 5px;
                        text-align: left;
                    }
                    .unit-header {
                        background-color: #f2f2f2;
                    }
                </style>
            </head>
            <body>
                <xsl:apply-templates select="//xliff:file/xliff:body/xliff:trans-unit"/>
            </body>
        </html>
    </xsl:template>

    <!-- Template for each translation unit -->
    <xsl:template match="xliff:trans-unit">
        <table class="unit-table">
            <tr class="unit-header">
                <th colspan="2">
                    <xsl:value-of select="concat('Translation Unit ', format-number(position(), '00000'))"/>
                </th>
            </tr>
            <xsl:if test="xliff:source/xliff:mrk[@mtype='protected']">
                <tr>
                    <td>Translator's Comment:</td>
                    <td>
                        <xsl:value-of select="xliff:source/xliff:mrk[@mtype='protected']"/>
                    </td>
                </tr>
            </xsl:if>
            <tr>
                <td>Source:</td>
                <td>
                    <!-- Output text nodes only, stripping out tags -->
                    <xsl:for-each select="xliff:source/node()">
                        <xsl:if test="self::text()">
                            <xsl:value-of select="."/>
                        </xsl:if>
                    </xsl:for-each>
                </td>
            </tr>
            <tr>
                <td>Target:</td>
                <td><xsl:value-of select="xliff:target"/></td>
            </tr>
        </table>
    </xsl:template>

</xsl:stylesheet>