from xml.etree import ElementTree as ET
import os

def copy_source_to_target(xliff_path):
    # Register the namespaces to prevent them from being added to each element
    ET.register_namespace('', "urn:oasis:names:tc:xliff:document:1.2")
    
    # Parse the XLIFF file
    tree = ET.parse(xliff_path)
    root = tree.getroot()
    
    # Iterate over each trans-unit element and copy source to target
    for trans_unit in root.findall('.//{urn:oasis:names:tc:xliff:document:1.2}trans-unit'):
        source = trans_unit.find('{urn:oasis:names:tc:xliff:document:1.2}source').text
        target = trans_unit.find('{urn:oasis:names:tc:xliff:document:1.2}target')
        
        # If source text is not None, copy it to the target element
        if source is not None:
            target.text = source
            target.set('state', 'translated')  # Update the 'state' attribute

    # Define the new file name
    base_name = os.path.basename(xliff_path)
    new_file_name = f'updated_{base_name}'
    
    # Save the updated XLIFF file
    tree.write(new_file_name, encoding='utf-8', xml_declaration=True)
    
    return new_file_name

# Prompt the user for the original XLIFF file path
original_file_path = input("Please enter the path to the Original Paligo XLIFF file: ")
updated_file_path = copy_source_to_target(original_file_path)
print(f"The updated file has been saved as: {updated_file_path}")